function image_data=rd_img16_substack(filename,firstimage,lastimage)

% Reads substack delimited by first and last images
% By EP 2014

info = imfinfo(filename);

image_data = uint16(zeros(info(1).Height,info(1).Width,length(firstimage:lastimage))); % preallocate 3-D array 

h = waitbar(0,'Loading image series...');
images=firstimage:lastimage;
for frame=1:length(images)
  
    [image_data(:,:,frame),map] = imread(filename,images(frame));
    waitbar(frame/size(info,1),h)
end

close(h)